/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class DynaProperty
implements Serializable {
    private static final int BOOLEAN_TYPE = 1;
    private static final int BYTE_TYPE = 2;
    private static final int CHAR_TYPE = 3;
    private static final int DOUBLE_TYPE = 4;
    private static final int FLOAT_TYPE = 5;
    private static final int INT_TYPE = 6;
    private static final int LONG_TYPE = 7;
    private static final int SHORT_TYPE = 8;
    protected String name = null;
    protected transient Class type = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;

    public boolean isIndexed() {
        if (this.type == null) {
            return false;
        }
        if (this.type.isArray()) {
            return true;
        }
        return (class$java$util$List == null ? (class$java$util$List = DynaProperty.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.type);
    }

    public boolean isMapped() {
        if (this.type == null) {
            return false;
        }
        return (class$java$util$Map == null ? (class$java$util$Map = DynaProperty.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.type);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block11: {
            block10: {
                if (!in.readBoolean()) break block10;
                switch (in.readInt()) {
                    case 1: {
                        this.type = Boolean.TYPE;
                        break block11;
                    }
                    case 2: {
                        this.type = Byte.TYPE;
                        break block11;
                    }
                    case 3: {
                        this.type = Character.TYPE;
                        break block11;
                    }
                    case 4: {
                        this.type = Double.TYPE;
                        break block11;
                    }
                    case 5: {
                        this.type = Float.TYPE;
                        break block11;
                    }
                    case 6: {
                        this.type = Integer.TYPE;
                        break block11;
                    }
                    case 7: {
                        this.type = Long.TYPE;
                        break block11;
                    }
                    case 8: {
                        this.type = Short.TYPE;
                        break block11;
                    }
                    default: {
                        throw new StreamCorruptedException("Invalid primitive type. Check version of beanutils used to serialize is compatible.");
                    }
                }
            }
            this.type = (Class)in.readObject();
        }
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int primitiveType = 0;
        if (Boolean.TYPE.equals(this.type)) {
            primitiveType = 1;
        } else if (Byte.TYPE.equals(this.type)) {
            primitiveType = 2;
        } else if (Character.TYPE.equals(this.type)) {
            primitiveType = 3;
        } else if (Double.TYPE.equals(this.type)) {
            primitiveType = 4;
        } else if (Float.TYPE.equals(this.type)) {
            primitiveType = 5;
        } else if (Integer.TYPE.equals(this.type)) {
            primitiveType = 6;
        } else if (Long.TYPE.equals(this.type)) {
            primitiveType = 7;
        } else if (Short.TYPE.equals(this.type)) {
            primitiveType = 8;
        }
        if (primitiveType == 0) {
            out.writeBoolean(false);
            out.writeObject(this.type);
        } else {
            out.writeBoolean(true);
            out.writeInt(primitiveType);
        }
        out.defaultWriteObject();
    }

    public Class getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DynaProperty[name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        sb.append("]");
        return sb.toString();
    }

    public DynaProperty(String name) {
        this(name, class$java$lang$Object == null ? (class$java$lang$Object = DynaProperty.class$("java.lang.Object")) : class$java$lang$Object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public DynaProperty(String name, Class type) {
        this.name = name;
        this.type = type;
    }
}

